<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* Functions to access the CI loader when the CI instance is not in scope.
* @package direct-project-innovation-initiative
* @subpackage helpers
* @filesource
*/

/**
* Shortcut to load a helper when you're outside of the CI instance.
* This is particularly helpful when you want to load dependent helper files from within a helper or a library.
* You should use this instead of directly including/requiring the file in order to ensure that any application-specific extensions get uploaded.
* @param string Name of the helper (e.g. 'string', 'array', 'url', etc.)
*/
function load_helper($helper){
	$CI = get_instance();
	return $CI->load->helper($helper);
}

/**
* Shortcut to load several helpers at once when you're outside of the CI instance.
* Like {@link load_helper}, but allows you to load multiple helpers at once.  
* This function can take any number of parameters; just enter the names of the helpers you need.
* <code>load_helpers('array', 'string', 'url', 'inflector')</code>
*/
function load_helpers(){
	$array_of_helpers = func_get_args();
	foreach($array_of_helpers as $helper)
		load_helper($helper);
}

/**
* Shortcut to load a library when you're outside of the CI instance.
* This is particularly helpful when you want to load dependent library files from within a helper or a library.
* You should use this instead of directly including/requiring the file in order to ensure that any application-specific extensions get uploaded.
* @param string Name of the library (e.g. 'string', 'array', 'url', etc.)
*/
function load_library($library){
	$CI = get_instance();
	return $CI->load->library($library);
}

/**
* Shortcut to load several libraries at once when you're outside of the CI instance.
* Like {@link load_library}, but allows you to load multiple libraries at once.  
* This function can take any number of parameters; just enter the names of the libraries you need.
* <code>load_libraries('object', 'validator')</code>
*/
function load_libraries(){
	$array_of_libraries = func_get_args();
	foreach($array_of_libraries as $library){
		load_library($library);
	}
}

?>